/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.update;

import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.services.TransportService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.transport.Transport;
import de.willuhn.jameica.update.PluginGroup;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PluginData {
    private PluginGroup group = null;
    private Manifest manifest = null;

    protected PluginData(PluginGroup group, URL url) throws Exception {
        this.group = group;
        Object s = url.toString();
        if (!((String)s).endsWith("/")) {
            s = (String)s + "/";
        }
        URL plugin = new URL((String)s + "plugin.xml");
        Logger.debug((String)("reading " + plugin));
        TransportService service = (TransportService)Application.getBootLoader().getBootable(TransportService.class);
        Transport t = service.getTransport(plugin);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.get(bos, null);
            this.manifest = new Manifest(new ByteArrayInputStream(bos.toByteArray()));
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)("error while downloading " + plugin), (Throwable)e);
            throw new OperationCanceledException(plugin + " not found");
        }
    }

    public String getName() {
        return this.manifest.getName();
    }

    public long getSize() {
        try {
            TransportService service = (TransportService)Application.getBootLoader().getBootable(TransportService.class);
            Transport t = service.getTransport(this.getDownloadUrl());
            return t.getSize();
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine download size", (Throwable)e);
            return -1L;
        }
    }

    public PluginGroup getPluginGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.manifest.getDescription();
    }

    public URL getDownloadUrl() throws ApplicationException {
        try {
            return new URL(this.manifest.getURL());
        }
        catch (Exception e) {
            Logger.error((String)"invalid manifest url", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Ung\u00fcltige Download-URL in Plugin-Definition: {0}", e.getMessage()));
        }
    }

    public URL getSignatureUrl() throws ApplicationException {
        try {
            return new URL(this.manifest.getURL() + ".sha1");
        }
        catch (Exception e) {
            Logger.error((String)"invalid signature url", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Ung\u00fcltige Signatur-URL in Plugin-Definition: {0}", e.getMessage()));
        }
    }

    public Version getAvailableVersion() {
        return this.manifest.getVersion();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public boolean isInstalledVersion() {
        Version installed = this.getInstalledVersion();
        if (installed == null) {
            return false;
        }
        return this.getAvailableVersion().equals(installed);
    }

    public Version getInstalledVersion() {
        Manifest mf = this.getInstalledManifest();
        return mf == null ? null : mf.getVersion();
    }

    public Manifest getInstalledManifest() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        List<Manifest> list = Application.getPluginLoader().getInstalledManifests();
        for (Manifest m : list) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public boolean isInstallable() {
        try {
            this.manifest.canDeploy();
            return true;
        }
        catch (ApplicationException ae) {
            Logger.debug((String)ae.getMessage());
            return false;
        }
    }

    public Dependency[] getDependencies() {
        Dependency[] dl;
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        Dependency jd = this.manifest.getJameicaDependency();
        if (jd != null) {
            deps.add(jd);
        }
        if ((dl = this.manifest.getDependencies()) != null && dl.length > 0) {
            for (Dependency d : dl) {
                if (d == null) continue;
                deps.add(d);
            }
        }
        return deps.toArray(new Dependency[deps.size()]);
    }
}

